<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Thrive_Quiz_Builder\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


/**
 * Ajax function for selecting percentage quizzes
 *
 * @since 1.0.0
 */
function automatorwp_thrive_quiz_builder_ajax_get_percentage_quiz() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );
    
    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( sanitize_text_field( $_REQUEST['q'] ) ) : '';

    $quizzes = automatorwp_thrive_quiz_builder_get_percentage_quizzes();

    $results = array();

    // Parse tag results to match select2 results
    foreach ( $quizzes as $quiz ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $quiz->post_title ), strtolower( $search ) ) === false ) {
                continue;
            }
        }
        
        $results[] = array(
            'id' => $quiz->ID,
            'text' => $quiz->post_title
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_thrive_quiz_builder_get_percentage_quiz', 'automatorwp_thrive_quiz_builder_ajax_get_percentage_quiz' );